/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class NumberLiteral
extends AstNode {
    private String value;
    private double number;

    public NumberLiteral() {
        this.type = 40;
    }

    public NumberLiteral(int pos) {
        super(pos);
        this.type = 40;
    }

    public NumberLiteral(int pos, int len) {
        super(pos, len);
        this.type = 40;
    }

    public NumberLiteral(int pos, String value2) {
        super(pos);
        this.type = 40;
        this.setValue(value2);
        this.setLength(value2.length());
    }

    public NumberLiteral(int pos, String value2, double number2) {
        this(pos, value2);
        this.setDouble(number2);
    }

    public NumberLiteral(double number2) {
        this.type = 40;
        this.setDouble(number2);
        this.setValue(Double.toString(number2));
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value2) {
        this.assertNotNull(value2);
        this.value = value2;
    }

    public double getNumber() {
        return this.number;
    }

    public void setNumber(double value2) {
        this.number = value2;
    }

    public String toSource(int depth) {
        return this.makeIndent(depth) + (this.value == null ? "<null>" : this.value);
    }

    public void visit(NodeVisitor v) {
        v.visit(this);
    }
}

